<?php declare(strict_types = 1);

namespace DynamicModule\DI;

use Core\DI\CompilerExtension;
use Nette;
use Nette\DI\Compiler;

class DynamicModuleExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$path = APP_DIR . '/config/app/dynamicModule.neon';
		if (!file_exists($path)) {
			throw new \RuntimeException('Please create dynamicModule.neon in app/config/app');
		}


		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['DynamicModule' => 'DynamicModule\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);

		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('DynamicModule\Model\DynamicModuleConfig::setParams($this->parameters[\'dynamicModule\']);');
	}
}
