<?php declare(strict_types=1);

namespace DynamicModule\FrontModule\Model\Dao;

use Nette\SmartObject;

/**
 * Class Field
 * @package DynamicModule\FrontModule\Model\Dao
 * @property-read int $id
 * @property-read string $key
 * @property-read string $lang
 * @property string $value
 */
class Field
{
	use SmartObject;

	/** @var int */
	protected int $id;

	/** @var string */
	protected string $key;

	/** @var string|null */
	protected ?string $value;

	/** @var string|null */
	protected ?string $lang;

	/**
	 * Field constructor.
	 * @param string $key
	 * @param string|null $value
	 * @param string|null $lang
	 * @param int $id
	 */
	public function __construct(string $key, ?string $value, ?string $lang, int $id)
	{
		$this->key = $key;
		$this->value = $value;
		$this->lang = $lang;
		$this->id = $id;
	}

	/**
	 * @return int
	 */
	public function getId(): int
	{
		return $this->id;
	}

	/**
	 * @return string
	 */
	public function getKey(): string
	{
		return $this->key;
	}

	/**
	 * @return string
	 */
	public function getValue(): ?string
	{
		return $this->value;
	}

	/**
	 * @param string $value
	 */
	public function setValue(string $value): void
	{
		$this->value = $value;
	}

	/**
	 * @return string|null
	 */
	public function getLang(): ?string
	{
		return $this->lang;
	}

}
