<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Dao;

use Nette\SmartObject;

/**
 * Class Group
 * @package DynamicModule\FrontModule\Model\Dao
 * @property-read int      $id
 * @property string        $title
 * @property string        $template
 * @property int           $lvl
 * @property self[]        $children
 * @property int|self|null $parent
 * @property Member[]      $members
 * @property Field[]       $fields
 */
class Group implements IFields
{
	use SmartObject;
	use TFields;

	/** @var int */
	protected int $id;

	/** @var string */
	protected string $title;

	/** @var string */
	protected string $template;

	/** @var int */
	protected int $lvl;

	/** @var self[] */
	protected array $children;

	/** @var Member[] */
	protected array $members;

	/** @var int|self|null */
	public $parent;

	/**
	 * Group constructor.
	 *
	 * @param int    $id
	 * @param string $title
	 * @param string $template
	 */
	public function __construct(int $id, string $title, string $template)
	{
		$this->id       = $id;
		$this->title    = $title;
		$this->template = $template;
		$this->children = [];
		$this->members  = [];
		$this->fields   = [];
	}

	/**
	 * @return int
	 */
	public function getId(): int
	{
		return $this->id;
	}

	/**
	 * @return string
	 */
	public function getTitle(): string
	{
		return $this->title;
	}

	/**
	 * @param string $title
	 */
	public function setTitle(string $title): void
	{
		$this->title = $title;
	}

	/**
	 * @return string
	 */
	public function getTemplate(): string
	{
		return $this->template;
	}

	/**
	 * @param string $template
	 */
	public function setTemplate(string $template): void
	{
		$this->template = $template;
	}

	/**
	 * @return int
	 */
	public function getLvl(): int
	{
		return $this->lvl;
	}

	/**
	 * @param int $lvl
	 */
	public function setLvl(int $lvl): void
	{
		$this->lvl = $lvl;
	}

	/**
	 * @return self[]
	 */
	public function getChildren(): array
	{
		return $this->children;
	}

	/**
	 * @param Group[] $children
	 */
	public function setChildren(array $children): void
	{
		$this->children = $children;
	}

	/**
	 * @return Member[]
	 */
	public function getMembers(): array
	{
		return $this->members;
	}

	public function findMember(int $id): ?Member
	{
		if (isset($this->getMembers()[$id]))
			return $this->getMembers()[$id];

		foreach ($this->getChildren() as $child) {
			$member = $child->findMember($id);

			if ($member)
				return $member;
		}

		return null;
	}

	public function removeMember($key): void
	{
		unset($this->members[$key]);
	}

	/**
	 * @param Member[] $members
	 */
	public function setMembers(array $members): void
	{
		$this->members = $members;
	}

}
