<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Dao;

use Core\FrontModule\Model\Dao\Seo;
use Nette\SmartObject;

/**
 * Class Member
 * @package DynamicModule\FrontModule\Model\Dao
 * @property-read int    $id
 * @property string      $title
 * @property string|null $lang
 * @property string      $template
 * @property Field[]     $fields
 */
class Member implements IFields
{
	use SmartObject;
	use TFields;

	/** @var int */
	protected int $id;

	/** @var string */
	protected string $title;

	/** @var string|null */
	protected ?string $lang;

	/** @var string */
	protected string $template;

	protected array $groupIds = [];

	public ?Seo $seo = null;

	/**
	 * Member constructor.
	 *
	 * @param int    $id
	 * @param string $title
	 * @param string $template
	 */
	public function __construct(int $id, string $title, string $template)
	{
		$this->id       = $id;
		$this->title    = $title;
		$this->template = $template;
	}

	/**
	 * @return int
	 */
	public function getId(): int
	{
		return $this->id;
	}

	/**
	 * @return string
	 */
	public function getTitle(): string
	{
		return $this->title;
	}

	/**
	 * @param string $title
	 */
	public function setTitle(string $title): void
	{
		$this->title = $title;
	}

	/**
	 * @return string|null
	 */
	public function getLang(): ?string
	{
		return $this->lang;
	}

	/**
	 * @param string|null $lang
	 */
	public function setLang(?string $lang): void
	{
		$this->lang = $lang;
	}

	/**
	 * @return string
	 */
	public function getTemplate(): string
	{
		return $this->template;
	}

	/**
	 * @param string $template
	 */
	public function setTemplate(string $template): void
	{
		$this->template = $template;
	}

	public function setGroupIds(array $groupIds): void { $this->groupIds = $groupIds; }

	public function getGroupIds(): array { return $this->groupIds; }
}
