<?php declare(strict_types=1);

namespace DynamicModule\FrontModule\Model\Dao;

trait TFields
{
	/** @var Field[] */
	protected array $fields;

	/**
	 * @inheritDoc
	 */
	public function getField(string $key): ?Field
	{
		return $this->fields[$key] ?? null;
	}

	/**
	 * @inheritDoc
	 */
	public function getFieldValue(string $key)
	{
		if (!$this->getField($key)) {
			return null;
		}

		return $this->getField($key)->getValue() ?? null;
	}

	/**
	 * @inheritDoc
	 */
	public function getFields(): array
	{
		return $this->fields;
	}

	/**
	 * @inheritDoc
	 */
	public function setFields(array $fields): void
	{
		$this->fields = $fields;
	}

	public function getKeyValueData():array {
		$arr = [];

		foreach ($this->getFields() as $k => $v) {
			$arr[$k] = $v->getValue();
		}

		return $arr;
	}
}
