<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Repository;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\ParameterType;
use DynamicModule\Model\Entities\Field;
use DynamicModule\FrontModule\Model\Dao;
use Nette\Localization\ITranslator;

class Fields extends BaseEntityService
{
	/** @var string */
	protected $entityClass = Field::class;

	public ITranslator $translator;

	protected array $cEntities = [];

	public function __construct(ITranslator $translator)
	{
		$this->translator = $translator;
	}

	/**
	 * @param int $groupId
	 *
	 * @return Dao\Field[]
	 */
	public function getByGroup(int $groupId): array
	{
		return $this->getByEntities('dynamicmodule__group_fields', 'group_id', [$groupId])[$groupId] ?? [];
	}

	/**
	 * @param int[] $groupIds
	 *
	 * @return Dao\Field[][]
	 */
	public function getByGroups(array $groupIds): array
	{
		return $this->getByEntities('dynamicmodule__group_fields', 'group_id', $groupIds);
	}

	/**
	 * @param int $memberId
	 *
	 * @return Dao\Field[]
	 */
	public function getByMember(int $memberId): array
	{
		return $this->getByEntities('dynamicmodule__member_fields', 'member_id', [$memberId])[$memberId] ?? [];
	}

	/**
	 * @param int[] $memberIds
	 *
	 * @return Dao\Field[][]
	 */
	public function getByMembers(array $memberIds): array
	{
		return $this->getByEntities('dynamicmodule__member_fields', 'member_id', $memberIds);
	}

	protected function getByEntities(string $joinTable, string $joinColumn, array $ids): array
	{
		$tmp  = [];
		$oIds = $ids;

		foreach ($ids as $k => $id) {
			if (isset($this->cEntities[$joinColumn][$id])) {
				$tmp[$id] = $this->cEntities[$joinColumn][$id];
				unset($ids[$k]);
			}
		}

		if (!empty($ids)) {
			$metadata  = $this->em->getClassMetadata($this->entityClass);
			$columns   = implode(', ', array_map(fn(string $col): string => "`{$col}`", $metadata->getColumnNames()));
			$tableName = $metadata->getTableName();

			if (!$columns || !$tableName)
				return [];

			$sql    = "SELECT {$columns}, jt.{$joinColumn} FROM {$tableName} t JOIN {$joinTable} jt ON t.id = jt.field_id 
						WHERE jt.{$joinColumn} IN (:ids) AND (t.lang = :lang OR t.lang IS NULL)";
			$values = [
				'ids'  => $ids,
				'lang' => $this->translator->getLocale(),
			];
			$types  = [
				'ids'  => Connection::PARAM_INT_ARRAY,
				'lang' => ParameterType::STRING];
			$stmt   = $this->em->getConnection()->executeQuery($sql, $values, $types);

			foreach ($stmt->fetchAll() as $row) {
				$row['id']                           = (int) $row['id'];
				$tmp[$row[$joinColumn]][$row['key']] = new Dao\Field(...array_values($row));
			}

			foreach ($tmp as $id => $v)
				$this->cEntities[$joinColumn][$id] = $v;
		}

		$result = [];
		foreach ($oIds as $id)
			if (isset($tmp[$id]))
				$result[$id] = $tmp[$id];

		return $result;
	}
}
