<?php declare(strict_types=1);

namespace DynamicModule\FrontModule\Model\Templating\Filters;

use DynamicModule\FrontModule\Model\Dao\IFields;

class FieldsFilter
{
	/**
	 * @param IFields $fields
	 * @param string $key
	 * @param mixed|null $fallback
	 * @return mixed|null
	 */
	public function __invoke(?IFields $fields, string $key, $fallback = null)
	{
		if (!$fields) {
			return '';
		}
		if ($fields->getFieldValue($key) !== null) {
			return $fields->getFieldValue($key) ?? '';
		}
		if ($fallback) {
			if (is_scalar($fallback)) {
				return $fields->getFieldValue($fallback) ?? '';
			} else if (is_array($fallback)) {
				foreach ($fallback as $f) {
					if ($fields->getFieldValue($f) !== null) {
						return $fields->getFieldValue($f);
					}
				}
			}
		}

		return '';
	}

}