<?php declare(strict_types=1);

namespace DynamicModule\FrontModule\Model\Templating;

use Latte\Compiler;
use Latte\MacroNode;
use Latte\Macros\MacroSet;
use Latte\PhpWriter;
use Latte;

class Macros extends MacroSet
{
	/**
	 * @param Compiler $compiler
	 * @return static
	 */
	public static function install(Compiler $compiler)
	{
		$me = new static($compiler);

		/**
		 * {dmgallery [$galleryId, $toVar]]}
		 */
		$me->addMacro('dmgallery', [$me, 'macroDmgallery']);

		return $me;
	}

	/**
	 * @param MacroNode $node
	 * @param PhpWriter $writer
	 * @return string
	 * @throws \Latte\CompileException
	 */
	public function macroDmgallery(MacroNode $node, PhpWriter $writer)
	{
		$param = $node->args;
		$params = array_map('trim', explode(',', $param));
		$galleryId = $node->tokenizer->fetchWord();
		$node->tokenizer->reset();

		return $writer->write(
			'$galleryId = %node.word;
			$' . $params[1] . ' = $this->global->uiPresenter->context->hasService(\'gallery.front.albums\') ? $this->global->uiPresenter->context->getService(\'gallery.front.albums\')->get($galleryId) : null;
		');
	}

}