<?php declare(strict_types=1);

namespace DynamicModule\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="dynamicmodule__group_member")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class GroupMember
{
	use TId;

	/**
	 * @var Group
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="Group", inversedBy="members")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Group $group;

	/**
	 * @var Member
	 * @ORM\ManyToOne(targetEntity="Member", inversedBy="groups")
	 * @ORM\JoinColumn(name="member_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Member $member;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	public int $position;

	/**
	 * GroupMember constructor.
	 * @param Group $group
	 * @param Member $member
	 */
	public function __construct(Group $group, Member $member)
	{
		$this->group = $group;
		$this->member = $member;
		$this->position = -1;
	}

}