<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use DynamicModule\Model\Traits\TPublished;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="dynamicmodule__group_text")
 * @ORM\Entity
 */
class GroupText
{
	use TPublished;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Group", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Group $group;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2, nullable=true)
	 */
	protected string $lang;

	public function __construct(Group $group, string $lang)
	{
		$this->group = $group;
		$this->lang  = $lang;
	}

	public function getGroup(): Group
	{
		return $this->group;
	}

	public function getLang(): string
	{
		return $this->lang;
	}
}
