<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\Entities\TId;
use Core\Model\Entities\TLang;
use Core\Model\TemplateReader\Entity\ITemplate;
use DynamicModule\Model\Traits\TFields;
use DynamicModule\Model\Traits\TTemplate;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use DynamicModule\Model\Traits\TPublished;
use Gedmo\Mapping\Annotation as Gedmo;
use Nette\Utils\Validators;

/**
 * @ORM\Table(name="dynamicmodule__member")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class Member implements ITemplate
{
	use TId;
	use TLang;

	/** @deprecated */
	use TPublished;

	use TTemplate;
	use TFields;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public string $title;

	/**
	 * @var ArrayCollection|GroupMember[]
	 * @ORM\OneToMany(targetEntity="GroupMember", mappedBy="member", cascade={"all"}, orphanRemoval=true)
	 */
	public $groups;

	/**
	 * @var ArrayCollection|Field[]
	 * @ORM\ManyToMany(targetEntity="DynamicModule\Model\Entities\Field", cascade={"persist"}, orphanRemoval=true)
	 * @ORM\JoinTable(name="dynamicmodule__member_fields")
	 */
	public $fields;

	/**
	 * @var ArrayCollection|MemberText[]
	 * @ORM\OneToMany(targetEntity="MemberText", mappedBy="member", indexBy="lang")
	 */
	public $texts;

	/**
	 * Member constructor.
	 * @param string $title
	 * @param string $template
	 */
	public function __construct(string $title, string $template)
	{
		$this->title = $title;
		$this->groups = new ArrayCollection;
		$this->template = $template;
		$this->fields = new ArrayCollection;
		$this->texts = new ArrayCollection;
	}

	/**
	 * @return Group[]
	 */
	public function getGroups(): array
	{
		return array_map(fn(GroupMember $groupMember): Group => $groupMember->group, $this->groups->toArray());
	}

	/**
	 * @param Group $group
	 */
	public function addGroup(Group $group): void
	{
		$this->groups->add(new GroupMember($group, $this));
	}

	/**
	 * @param Group $group
	 */
	public function removeGroup(Group $group): void
	{
		/** @var GroupMember $groupMember */
		foreach ($this->groups->toArray() as $groupMember) {
			if ($groupMember->group->getId() === $group->getId() && $groupMember->member->getId() === $this->getId()) {
				$this->groups->removeElement($groupMember);
			}
		}
	}

	public function addEntityText(MemberText $text): self
	{
		$this->texts->add($text);

		return $this;
	}

	public function setEntityText(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

	/**
	 * @return MemberText[]
	 */
	public function getEntityTexts(): array
	{
		$result = [];
		/** @var MemberText $text */
		foreach ($this->texts->toArray() as $text) {
			$result[$text->getLang()] = $text;
		}

		return $result;
	}

}