<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Core\Model\Entities\Seo;
use DynamicModule\Model\Traits\TPublished;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="dynamicmodule__member_text")
 * @ORM\Entity
 */
class MemberText
{
	use TPublished;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Member", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="member_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Member $member;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2, nullable=true)
	 */
	protected string $lang;

	/**
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Seo")
	 * @ORM\JoinColumn(name="seo_id", referencedColumnName="id", onDelete="SET NULL", nullable=true)
	 */
	public ?Seo $seo = null;

	public function __construct(Member $member, string $lang)
	{
		$this->member = $member;
		$this->lang   = $lang;
	}

	public function getMember(): Member
	{
		return $this->member;
	}

	public function getLang(): string
	{
		return $this->lang;
	}
}
