<?php declare(strict_types = 1);

namespace DynamicModule\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\Helpers\Arrays;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use DynamicModule\FrontModule\Model\Dao\Group;
use DynamicModule\FrontModule\Model\Repository\IGroupsFactory;
use DynamicModule\Model\DynamicModuleConfig;
use DynamicModule\Model\Repository\Groups;
use DynamicModule\Model\Repository\Members;
use EshopCatalog\DI\EshopCatalogExtension;
use EshopCatalog\FrontModule\Model\ProductsFacade;
use Nette\DI\Container;

class GroupMembersTemplateText extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'groupMembers';

	protected Groups $groups;

	protected Members $members;

	protected IGroupsFactory $groupsFrontRepoFactory;

	protected Container $diContainer;

	public function __construct(Groups $groups, Members $members, IGroupsFactory $groupsFrontRepoFactory, Container $diContainer)
	{
		$this->groups                 = $groups;
		$this->members                = $members;
		$this->groupsFrontRepoFactory = $groupsFrontRepoFactory;
		$this->diContainer            = $diContainer;
	}

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		if (isset($params['default']))
			return;

		if (!isset($params['module'])) {
			throw new \Nette\InvalidArgumentException('Parameter \'module\' must by specified');
		}

		$qb = $this->groups->getQueryBuilderByModule($params['module'])
			->addOrderBy('g.title');

		if (!DynamicModuleConfig::load('multiLangPublication')) {
			$qb->andWhere('g.isPublished = 1');
		}

		$groups = [];
		foreach ($qb->getQuery()->getResult() as $g) {
			$groups[] = [
				'id'     => $g->getId(),
				'parent' => $g->parent ? $g->parent->getId() : 0,
				'name'   => $g->title,
			];
		}

		$formContainer->addCheckboxNestedList($this->getName(), $this->getTitle(), $groups);
	}

	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		if (isset($params['default']))
			$this->default = explode(',', $params['default']);

		$moduleName = $params['module'] ?? null;

		if (!$moduleName) {
			throw new InvalidArgumentException('Module name is missing');
		}

		if (!is_iterable($this->getDefault()) || count($this->getDefault()) === 0) {
			return [];
		}

		$groups = $this->groupsFrontRepoFactory->create($moduleName);

		/** @var Group[] $result */
		$result = $groups->getByIds($this->getDefault());

		$members = [];
		if (isset($params['onlyMembers'])) {
			foreach ($result as $group) {
				$members += $group->getMembers();
			}

			$result = $members;
		};

		if (isset($params['shuffle']) && $result)
			$result = Arrays::shuffleAssoc($result);

		if (isset($params['limit']))
			$result = array_slice($result, 0, (int) $params['limit'], true);

		if (class_exists(EshopCatalogExtension::class) && $this->diContainer->hasService('eshopCatalog.front.productsFacade')) {
			$products = [];
			/** @var ProductsFacade $productsFacade */
			$productsFacade = $this->diContainer->getService('eshopCatalog.front.productsFacade');

			foreach ($result as $group) {
				foreach ($group->getMembers() as $member) {
					if ($member->getFieldValue('productId'))
						$products[] = $member->getFieldValue('productId');
				}
			}

			if ($products)
				$productsFacade->getProducts($products);
		}

		return $result;
	}

}
