<?php declare(strict_types=1);

namespace DynamicModule\Model\TemplateTextType;

use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use DynamicModule\FrontModule\Model\Dao\Member;
use DynamicModule\FrontModule\Model\Repository\Members;
use Nette\Localization\ITranslator;
use Nette\Utils\Arrays;

class MembersTemplateText extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'members';

	protected Members $members;

	protected ITranslator $translator;

	/**
	 * MembersTemplateText constructor.
	 * @param Members $members
	 * @param ITranslator $translator
	 */
	public function __construct(Members $members, ITranslator $translator)
	{
		$this->members = $members;
		$this->translator = $translator;
	}

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$membersAssoc = ['' => null];

		if (!isset($params['module'])) {
			throw new \Nette\InvalidArgumentException('Parameter \'module\' must by specified');
		}

		$members = $this->members->getByModule($params['module'], false);
		foreach ($members as $member) {
			if (!isset($membersAssoc[$member->getId()]) || $member->getLang() == $this->translator->getLocale()) {
				$membersAssoc[$member->getId()] = $member->getTitle();
			}
		}

		if (isset($params['multiple']) && $params['multiple'] == true) {
			unset($membersAssoc[array_key_first($membersAssoc)]);
			$formContainer->addCheckboxList($this->getName(), $this->getTitle(), $membersAssoc);
		} else {
			$formContainer->addSelect($this->getName(), $this->getTitle(), $membersAssoc);
		}
	}

	public function render($params)
	{
		$default = $this->getDefault();
		if (isset($params['multiple']) && $params['multiple'] == true) {
			$result = $this->members->getByIds(is_array($default) ? $default : explode(',', $default));

			if (isset($params['limit'])) {
				return array_slice($result, 0, (int) $params['limit']);
			}
			
			return $result;
		} else {
			return $this->members->getById(is_array($default) ? ((int) Arrays::first($default)) : ((int) $default));
		}
	}
}
