<?php declare(strict_types = 1);

namespace DynamicModule\Model\Traits;

use Doctrine\Common\Collections\ArrayCollection;
use DynamicModule\Model\Entities\Field;
use Nette\Utils\Arrays;

/**
 * Trait TTemplate
 * @package DynamicModule\Model\Traits
 *
 * @property ArrayCollection $fields
 */
trait TTemplate
{
	/**
	 * @var string
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $template;

	/**
	 * @param string $text
	 *
	 * @return string|array|null
	 */
	public function getText($text)
	{
		return $this->getFieldsValues()[$text] ?? '';
	}

	/**
	 * @return array
	 */
	public function getTexts(): array
	{
		return $this->getFieldsValues();
	}

	/**
	 * @param array $texts
	 */
	public function setTexts($texts): void
	{

		// tento kod je pro tt, ktere maji vice inputu (jak je napr. image)
		$existFields = $this->getFieldsByKey();
		foreach ($texts as $k => $v) {
			if (is_array($v) && !Arrays::every(array_keys($v), fn ($val) => strlen($val) === 2)) { // napr tt image ktere ma 3 inputy
				foreach ($v as $k1 => $v1) {
					$texts[$k1] = $v1;
				}
				unset($texts[$k]);
				foreach ($existFields as $defK => $defV) {
					if ($defK === $k) {
						if (is_array($defV)) {
							if (!is_array($texts[$k])) {
								// if new value is not multiLang
								foreach ($defV as $lang => $field)
									$this->fields->removeElement($field);

								unset($existFields[$defK]);
								break;
							}
						} else {
							if (is_array($v)) {
								// if new value is multiLang
								$this->fields->removeElement($existFields[$defK]);
								unset($existFields[$defK]);
								break;
							}
						}

						break;
					}
				}
			}
		}

		foreach ($texts as $k => $v) {
			// edit
			$break = false;
			/** @var Field $defV */
			foreach ($existFields as $defK => $defV) {
				if ($defK === $k) {
					if (is_array($defV)) {
						if (!is_array($texts[$k])) {
							// if new value is not multiLang
							foreach ($defV as $lang => $field)
								$this->fields->removeElement($field);

							unset($existFields[$defK]);
							break;
						} else {
							foreach ($defV as $lang => $field) {
								$field->value = $texts[$k][$lang] ?? null;
							}
						}
					} else {
						if (is_array($v)) {
							// if new value is multiLang
							$this->fields->removeElement($existFields[$defK]);
							unset($existFields[$defK]);
							break;
						} else
							$defV->value = $v;
					}

					$break = true;
					break;
				}
			}

			// add
			if (!$break) {
				if (is_array($v)) {
					foreach ($v as $lang => $val) {
						$this->fields->add(new Field($k, $val, $lang));
					}
				} else {
					$this->fields->add(new Field($k, $v));
				}
			}
		}

		// delete
		foreach (array_diff(array_keys($existFields), array_keys($texts)) as $key) {
			/** @var Field $value */
			foreach ($existFields as $defK => $value) {

				if ($defK === $key) {
					$this->fields->removeElement($value);
					break;
				}
			}
		}
	}

}
