document.addEventListener('click', e => {
	const target = e.target;

	if (target.dataset.saveNewFeatureValue !== undefined) {
		createFeatureValue(e);
	} else if (target.dataset.selectAdd !== undefined) {
		const baseItem = target.closest('.frm__type-select').querySelector('[data-select-base]');

		if (baseItem) {
			const baseItemSelect = baseItem.querySelector('select');

			const newItem = baseItem.cloneNode();
			newItem.removeAttribute('data-select-base');
			newItem.setAttribute('data-select-item', '');

			const selectWrap = document.createElement('div');
			selectWrap.style.flexGrow = '1';

			const select = document.createElement('select');
			select.setAttribute('name', baseItemSelect.getAttribute('name'));
			select.innerHTML = '<option value=""></option>';

			JSON.parse(baseItem.dataset.selectBase).forEach(v => {
				let option = document.createElement('option');
				option.value = v.id;
				option.text  = v.name;

				select.add(option);
			});

			select.value = '';

			const removeBtn = document.createElement('a');
			removeBtn.setAttribute('data-select-remove', '');
			removeBtn.href = 'javascript:;';
			removeBtn.classList.add('btn', 'btn-xs', 'btn-danger');
			removeBtn.innerHTML = '<span class="fa fa-times" style="pointer-events: none;"></span>';

			selectWrap.appendChild(select);
			newItem.appendChild(selectWrap);
			newItem.appendChild(removeBtn);

			baseItem.parentElement.appendChild(newItem);

			document.dispatchEvent(new CustomEvent('formInputsInit', {
				bubbles   : true,
				cancelable: true,
			}));
		}
	} else if (target.dataset.selectRemove !== undefined) {
		target.closest('[data-select-item]').remove();
	}
});

const createFeatureValue = (e) => {
	e.preventDefault();
	let el        = e.target;
	let featureId = el.dataset.createFeatureId;

	if (featureId) {
		let wrap = el.closest('.feature-values-list__feature');

		let link = el.closest('[data-link-create-value]').dataset.linkCreateValue.replace('__id__', featureId).replace('__val__', wrap.querySelector('[data-create-feature-input]').value);
		global.naja.makeRequest('get', link, [], {
			history: false,
		}).then(response => {
			let selects = wrap.querySelectorAll('select');
			let select  = selects[selects.length - 1];

			if (response.data.created) {
				let option   = document.createElement('option');
				option.value = response.data.id;
				option.text  = response.data.name;
				select.add(option);
			}

			select.value = response.data.id;
			el.value     = '';

			const choices = select.dataset.choicesIndex ? global.choicesList[select.dataset.choicesIndex] : null;
			if (choices) {
				choices.setChoices([{
					value: response.data.id, label: response.data.name,
				}], 'value', 'label', false);
				choices.setChoiceByValue(response.data.id);
			}
		});
	}

	e.preventDefault();
	return false;
};
