<?php declare(strict_types = 1);

namespace DynamicModule\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPosition;
use Core\Model\Helpers\Traits\TPublish;
use Doctrine\ORM\Query\Expr\Join;
use DynamicModule\Model\CacheService;
use DynamicModule\Model\Entities\Feature;

/**
 * @method Feature|null getReference($id)
 * @method Feature[] getAll()
 * @method Feature|null get($id)
 */
class Features extends BaseEntityService
{
	use TPublish;
	use TPosition;

	protected $entityClass = Feature::class;

	public function __construct(
		protected CacheService $cacheService,
		protected Translator   $translator,
	)
	{
	}

	public function getOptionsForSelect(): array
	{
		$result = [];

		foreach ($this->getEr()->createQueryBuilder('f')->select('f.id, ft.name')
			         ->innerJoin('f.texts', 'ft', Join::WITH, 'ft.lang = :lang')
			         ->setParameter('lang', $this->translator->getLocale())
			         ->orderBy('f.position')->getQuery()->getArrayResult() as $row) {
			$result[$row['id']] = $row['name'];
		}

		return $result;
	}
}
