<?php declare(strict_types = 1);

namespace DynamicModule\AdminModule\Presenters;

use Core\AdminModule\Model\Sites;
use Core\Model\UI\Form\BaseForm;
use DynamicModule\AdminModule\Components\VirtualUrl\IVirtualUrlFilterFormFactory;
use DynamicModule\AdminModule\Components\VirtualUrl\IVirtualUrlsGridFactory;
use DynamicModule\AdminModule\Components\VirtualUrl\VirtualUrlFilterForm;
use DynamicModule\AdminModule\Components\VirtualUrl\VirtualUrlsGrid;
use Nette\Application\Attributes\Persistent;
use Nette\Application\BadRequestException;

class ModuleVirtualUrlsPresenter extends BasePresenter
{
	#[Persistent]
	public string $siteIdent = '';

	public function __construct(
		protected Sites $sites
	)
	{
		parent::__construct();
	}

	/**
	 * @param mixed $element
	 *
	 * @throws BadRequestException
	 */
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getName(), 'access')) {
			$this->error();
		}
	}

	public function actionDefault(?string $siteIdent): void
	{
		$this->setHeader('dynamicModule.title.moduleVirtualUrls', 'fa fa-list');

		if (!$siteIdent) {
			$siteIdent = (string) array_keys($this->sites->getOptionsForSelect(true))[0];
		}

		$this->siteIdent = $siteIdent;

		$this->template->siteIdent = $siteIdent;
	}

	protected function createComponentVirtualUrlsGrid(IVirtualUrlsGridFactory $factory): VirtualUrlsGrid
	{
		$control = $factory->create($this->getParameter('siteIdent'));

		$control->filter = $this['virtualUrlFilterForm']->filter;

		return $control;
	}

	protected function createComponentVirtualUrlFilterForm(IVirtualUrlFilterFormFactory $factory): VirtualUrlFilterForm
	{
		$control = $factory->create($this->getParameter('siteIdent'));

		$control['form']->onSuccess[] = function(BaseForm $form, array $values): void {
			$this['virtualUrlsGrid']->filter = $values;
			$this['virtualUrlsGrid']['grid']->redrawControl('grid');
		};

		return $control;
	}
}
