<?php declare(strict_types = 1);

namespace DynamicModule\Console\MultihubInstagram;

use Exception;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Doctrine\ORM\Tools\SchemaTool;
use DynamicModule\Model\Services\MultihubInstagramService;
use Nette\DI\Attributes\Inject;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

#[AsCommand(name: 'dynamic-module:multihub-instagram:download-latest-media')]
class DownloadLatestMedia extends AbstractCommand
{
	#[Inject]
	public MultihubInstagramService $multihubInstagramService;

	protected function configure(): void
	{
		$this->setName('dynamic-module:multihub-instagram:download-latest-media');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui): int
	{
		$output->writeln('MultihubInstagram: Downloading latest media');

		try {
			$this->multihubInstagramService->downloadLatestMedia();

			$output->writeLn('<info>[OK] - downloaded</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
