<?php declare(strict_types = 1);

namespace DynamicModule\DI;

use Core\DI\CompilerExtension;
use DynamicModule\FrontModule\Model\Templating\Macros;
use Nette\Bridges\ApplicationLatte\LatteFactory;
use Nette\DI\Definitions\FactoryDefinition;
use Nette\PhpGenerator\ClassType;
use Nette\PhpGenerator\Literal;
use Override;
use RuntimeException;

class DynamicModuleExtension extends CompilerExtension
{
	#[Override]
	public function loadConfiguration(): void
	{
		$path = APP_DIR . '/config/app/dynamicModule.neon';
		if (!file_exists($path)) {
			throw new RuntimeException('Please create dynamicModule.neon in app/config/app');
		}

		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['DynamicModule' => 'DynamicModule\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		$factoryDefinition = $builder->getDefinitionByType(LatteFactory::class);
		assert($factoryDefinition instanceof FactoryDefinition);

		$factoryDefinition
			->getResultDefinition()
			->addSetup('?->onCompile[] = function ($engine) { ?::install($engine->getCompiler()); }', [
				'@self',
				new Literal(Macros::class),
			]);
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);

		$init = $class->getMethod('initialize');

		$init->addBody('DynamicModule\Model\DynamicModuleConfig::setParams($this->parameters[\'dynamicModule\']);');
		$init->addBody(
			'$this->getService(\'dynamicmodule.admin.groups\')->checkRoots($this->parameters[\'adminNavigation\']);',
		);
	}
}
