<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Dao;

use Core\FrontModule\Model\Dao\Seo;
use Nette\SmartObject;

/**
 * @property-read int      $id
 * @property string        $title
 * @property string        $template
 * @property int           $lvl
 * @property self[]        $children
 * @property int|self|null $parent
 * @property Member[]      $members
 * @property Field[]       $fields
 */
class Group implements IFields
{
	use SmartObject;
	use TFields;

	/** @var Member[] */
	protected array $members;
	/** @var self[] */
	protected array $children;
	/** @var int|self|null */
	public         $parent;
	public ?string $module = null;
	protected int  $lvl;
	public ?Seo    $seo    = null;
	public ?string $rod    = null;
	public array   $params = [];

	public function __construct(
		protected int    $id,
		protected string $title,
		protected string $template
	)
	{
		$this->children = [];
		$this->members  = [];
		$this->fields   = [];
	}

	public function getId(): int
	{
		return $this->id;
	}

	public function getTitle(): string
	{
		return $this->title;
	}

	public function setTitle(string $title): void
	{
		$this->title = $title;
	}

	public function getTemplate(): string
	{
		return $this->template;
	}

	public function setTemplate(string $template): void
	{
		$this->template = $template;
	}

	public function getLvl(): int
	{
		return $this->lvl;
	}

	public function setLvl(int $lvl): void
	{
		$this->lvl = $lvl;
	}

	/**
	 * @return self[]
	 */
	public function getChildren(): array
	{
		return $this->children;
	}

	/**
	 * @param Group[] $children
	 */
	public function setChildren(array $children): void
	{
		$this->children = $children;
	}

	/**
	 * @return Member[]
	 */
	public function getMembers(): array
	{
		return $this->members;
	}

	public function findMember(int $id): ?Member
	{
		if (isset($this->getMembers()[$id])) {
			return $this->getMembers()[$id];
		}

		foreach ($this->getChildren() as $child) {
			$member = $child->findMember($id);

			if ($member) {
				return $member;
			}
		}

		return null;
	}

	public function removeMember(int $key): void
	{
		unset($this->members[$key]);
	}

	/**
	 * @param Member[] $members
	 */
	public function setMembers(array $members): void
	{
		$this->members = $members;
	}

}
