<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Templating;

use Latte\Compiler;
use Latte\MacroNode;
use Latte\Macros\MacroSet;
use Latte\PhpWriter;

class Macros extends MacroSet
{

	public static function install(Compiler $compiler): Macros
	{
		$me = new Macros($compiler);

		/**
		 * {dmgallery [$galleryId, $toVar]]}
		 */
		$me->addMacro('dmgallery', $me->macroDmgallery(...));

		return $me;
	}

	public function macroDmgallery(MacroNode $node, PhpWriter $writer): string
	{
		$param     = $node->args;
		$params    = array_map('trim', explode(',', $param));
		$galleryId = $node->tokenizer->fetchWord();
		$node->tokenizer->reset();

		return $writer->write(
			'$galleryId = %node.word;
			$' . $params[1] . ' = $this->global->uiPresenter->context->hasService(\'gallery.front.albums\') ? $this->global->uiPresenter->context->getService(\'gallery.front.albums\')->get($galleryId) : null;
		',
		);
	}

}
