<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use DynamicModule\Model\Listeners\FeatureCacheListener;

#[ORM\Entity]
#[ORM\Table(name: 'dynamicmodule__feature_text')]
#[ORM\Index(name: 'columns', columns: ['id', 'lang'])]
#[ORM\EntityListeners([FeatureCacheListener::class])]
class FeatureText
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Feature::class, inversedBy: 'texts')]
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public Feature $feature;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2)]
	public string $lang;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $name = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $nameMulti = null;

	public function __construct(Feature $feature, string $lang)
	{
		$this->feature = $feature;
		$this->lang    = $lang;
	}
}
