<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Core\Model\Entities\TranslateListener;
use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use DynamicModule\Model\Listeners\FeatureCacheListener;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table(name: 'dynamicmodule__feature_value')]
#[ORM\Index(columns: ['id', 'is_published'], name: 'published')]
#[ORM\Entity]
#[ORM\EntityListeners([TranslateListener::class, FeatureCacheListener::class])]
class FeatureValue
{
	use TIdUnsigned;
	use TTranslateListener;

	#[Gedmo\SortableGroup]
	#[ORM\ManyToOne(targetEntity: Feature::class, inversedBy: 'values')]
	#[ORM\JoinColumn(name: 'feature_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public ?Feature $feature = null;

	/**
	 * @var Collection<string, FeatureValueText>
	 */
	#[ORM\OneToMany(mappedBy: 'featureValue', targetEntity: FeatureValueText::class, indexBy: 'lang')]
	public Collection $texts;

	#[Gedmo\SortablePosition]
	#[ORM\Column(type: Types::INTEGER, nullable: false, options: ['unsigned' => true, 'default' => 0])]
	public int $position = 0;

	#[ORM\Column(type: Types::SMALLINT, nullable: false, options: ['default' => 1])]
	public int $isPublished = 1;

	public function __construct()
	{
		$this->texts       = new ArrayCollection;
		$this->isPublished = 1;
		$this->setPosition(-1);
	}

	public function setPosition(int $position): self
	{
		$this->position = $position;

		return $this;
	}

	public function getPosition(): int { return $this->position; }
}
