<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use DynamicModule\Model\Listeners\FeatureCacheListener;

#[ORM\Table(name: 'dynamicmodule__feature_value_text')]
#[ORM\Index(name: 'feature_value', columns: ['id', 'lang'])]
#[ORM\Entity]
#[ORM\EntityListeners([FeatureCacheListener::class])]
class FeatureValueText
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: FeatureValue::class, inversedBy: 'featureValueTexts')]
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public FeatureValue $featureValue;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2)]
	public string $lang;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $name = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $rodM = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $rodZ = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $rodS = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $icon = null;

	public function __construct(FeatureValue $featureValue, string $lang)
	{
		$this->featureValue = $featureValue;
		$this->lang         = $lang;
	}
}
