<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Core\Model\Entities\Repository\SortableRepository;
use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table(name: 'dynamicmodule__group_member')]
#[ORM\Entity(repositoryClass: SortableRepository::class)]
class GroupMember
{
	use TId;

	#[Gedmo\SortableGroup]
	#[ORM\ManyToOne(targetEntity: Group::class, inversedBy: 'members')]
	#[ORM\JoinColumn(name: 'group_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public Group $group;

	#[ORM\ManyToOne(targetEntity: Member::class, inversedBy: 'groups')]
	#[ORM\JoinColumn(name: 'member_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public Member $member;

	#[Gedmo\SortablePosition]
	#[ORM\Column(name: 'position', type: Types::INTEGER)]
	public int $position = 0;

	public function __construct(Group $group, Member $member)
	{
		$this->group    = $group;
		$this->member   = $member;
		$this->position = -1;
	}

}
