<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ORM\Table(name: 'dynamicmodule__virtual_url_text')]
#[ORM\Index(name: 'dmvu_url_locale', columns: ['url', 'locale'])]
class VirtualUrlText
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: VirtualUrl::class, inversedBy: 'texts')]
	#[ORM\JoinColumn(name: 'id', nullable: false, onDelete: 'CASCADE')]
	protected VirtualUrl $virtualUrl;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $locale;

	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $url;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $seoTitle = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $seoDescription = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $title = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $description = null;

	#[ORM\Column(type: Types::JSON, nullable: true)]
	protected ?array $texts = null;

	public function __construct(VirtualUrl $virtualUrl, string $locale, string $url)
	{
		$this->virtualUrl = $virtualUrl;
		$this->locale     = $locale;
		$this->url        = $url;
	}

	public function getTexts(): array { return $this->texts ?: []; }

	/**
	 * @param string $key
	 *
	 * @return string
	 */
	public function getText($key) { return $this->texts[$key] ?? ''; }

	public function setTexts(array $texts): void
	{
		$this->texts = $texts;
	}
}
