<?php declare(strict_types = 1);

namespace DynamicModule\Model\Listeners;

use Doctrine\ORM\Event\PreFlushEventArgs;
use Core\Model\Lang\Langs;
use Doctrine;
use Doctrine\ORM\Mapping as ORM;
use DynamicModule\Model\CacheService;
use DynamicModule\Model\Entities\Feature;
use DynamicModule\Model\Entities\FeatureText;
use DynamicModule\Model\Entities\FeatureValue;
use DynamicModule\Model\Entities\FeatureValueText;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class FeatureCacheListener implements EventSubscriberInterface
{
	use SmartObject;

	protected CacheService $cacheService;
	protected Langs        $langs;

	public function __construct(
		CacheService $cacheService,
		Langs        $langs
	)
	{
		$this->cacheService = $cacheService;
		$this->langs        = $langs;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @param Feature|FeatureText|FeatureValue|FeatureValueText|object $entity
	 */
	#[ORM\PreFlush]
	public function onPreFlush(object $entity, PreFlushEventArgs $args): void
	{
		$key = null;
		if ($entity instanceof Feature) {
			$key = $entity->getId();
		} else if ($entity instanceof FeatureText) {
			$key = $entity->feature->getId();
		} else if ($entity instanceof FeatureValue) {
			$key = $entity->feature->getId();
		} else if ($entity instanceof FeatureValueText) {
			$key = $entity->featureValue->feature->getId();
		}

		if ($key) {
			$this->cacheService->removeFeature((int) $key);
		}
	}
}
