<?php declare(strict_types = 1);

namespace DynamicModule\Model\Subscribers;

use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Sites;
use Core\Model\TemplateReader\TemplateReader;
use DynamicModule\FrontModule\Model\FilterUrlHelper;
use DynamicModule\FrontModule\Model\Repository\IGroupsFactory;
use DynamicModule\FrontModule\Model\Repository\VirtualUrls;
use Navigations\Model\Event\RouteInEvent;
use Navigations\Model\Navigations;
use Nette\Http\Request;
use Nette\Utils\Json;
use Pages\FrontModule\Model\TemplatePages;
use Pages\Model\Paths;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class FilterUrlNavigationSubscriber implements EventSubscriberInterface
{
	public static array $lastVisitUpdated = [];

	public function __construct(
		protected EntityManagerDecorator $em,
		protected VirtualUrls            $virtualUrls,
		protected FilterUrlHelper        $filterUrlHelper,
		protected Navigations            $navigations,
		protected Sites                  $sites,
		protected Translator             $translator,
		protected Request                $request,
		protected TemplateReader         $templateReader,
		protected TemplatePages          $templatePages,
		protected Paths                  $pathsService,
		protected IGroupsFactory         $groupsFrontRepoFactory,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [
			Navigations::class . '::routeInNotFoundPreRedirect' => ['routeInNotFoundPreRedirect', 110],
		];
	}

	public function routeInNotFoundPreRedirect(RouteInEvent $event): void
	{
		$siteIdent = $this->sites->getCurrentSite()->getIdent();
		$url       = '/' . ltrim($event->urlParams['path'], '/');
		$locale    = $event->urlParams['locale'];

		$data = $this->virtualUrls->getByUrl($siteIdent, $locale, $url);

		if ($data) {
			$values = [];
			$navId  = $data['navigation'];

			foreach (explode(',', (string) $data['f']) as $v) {
				$values[] = (int) $v;
			}

			$navigation = $this->navigations->getNavigation($navId, $locale);
			if ($navigation) {
				$filter = [];
				foreach ($this->em->getConnection()->fetchAllAssociative("SELECT id, feature_id 
						FROM dynamicmodule__feature_value
						WHERE id IN (" . implode(',', $values) . ")") as $row) {
					$filter[$row['feature_id']][] = $row['id'];
				}

				if ($data['texts']) {
					$template = $this->templatePages->get((int) $navigation->componentParams['templatePage']);
					if ($template) {
						$templateName = $template->getTemplate();
						if (strpos($templateName, '|') === false) {
							$this->templateReader->setTemplatesDir($this->pathsService->getTemplatePagesDir('default'));
						} else {
							$tmp          = explode('|', $templateName, 2);
							$templateName = $tmp[1];
							$this->templateReader->setTemplatesDir($this->pathsService->getTemplatePagesDir($tmp[0]));
						}

						$templateInputs = $this->templateReader->getTemplateInputs($templateName);

						$data['texts'] = $this->templateReader->readRawData(Json::decode($data['texts'], Json::FORCE_ARRAY), $templateInputs);
					}
				} else {
					$data['texts'] = [];
				}

				if (!$data['title']) {
					$groupId = $navigation->componentParams['baseGroup'][0];

					$groupRepo = $this->groupsFrontRepoFactory->create($navigation->componentParams['module']);
					$group     = $groupRepo->getByIds([$groupId])[$groupId] ?? null;

					if ($group) {
						$tmp = $this->filterUrlHelper->generate($navigation->title, $filter, $group);

						$tmpTitle = $this->filterUrlHelper->addPrefixSuffix($navigation->title, $tmp['prefix'], $tmp['suffix']);

						$data['title'] = $tmpTitle;

						if (!$data['seo_title']) {
							$data['seo_title'] = $tmpTitle;
						}
					}
				}

				$navigation->setParam('virtualUrlData', $data);

				foreach ($filter as $k => $v) {
					$filter[$k] = implode('|', $v);
				}

				$return = [
					'presenter'        => 'DynamicModule:Front:Default',
					'action'           => 'group',
					'id'               => $navigation->componentParams['module'],
					'locale'           => $locale,
					'filter-filter'    => $filter,
					'activeNavigation' => $navigation,
				];

				$event->return = $return;
				$event->stopPropagation();
			}
		}
	}
}
