<?php declare(strict_types = 1);

namespace DynamicModule\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\SitemapGeneratorEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Thepixeldeveloper\Sitemap\Extensions\Link;
use Thepixeldeveloper\Sitemap\Url;

class SitemapSubscriber implements EventSubscriberInterface
{
	protected array $forRemove = [];

	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'sitemap.generate' => ['sitemapGenerate'],
		];
	}

	public function sitemapGenerate(SitemapGeneratorEvent $event): void
	{
		if ($event->group !== 'default') {
			return;
		}

		foreach ($this->em->getConnection()->fetchAllAssociative("SELECT vu.id, GROUP_CONCAT(DISTINCT CONCAT(vut.locale, '|', vut.url) SEPARATOR '||') as urls 
    				FROM dynamicmodule__virtual_url vu
    				INNER JOIN dynamicmodule__virtual_url_text vut ON vu.id = vut.id
					WHERE vu.site_ident = :site AND vu.add_to_sitemap = 1
					GROUP BY vu.id
    				", [
			'site' => $event->site->getIdent(),
		]) as $row) {
			$baseUrl   = null;
			$otherUrls = [];

			foreach (explode('||', $row['urls']) as $tmp) {
				$tmp = explode('|', $tmp);

				if ($tmp[0] === $event->lang) {
					$baseUrl = $tmp[1];
				} else {
					$otherUrls[$tmp[0]] = $tmp[1];
				}
			}

			if (!$baseUrl) {
				continue;
			}

			$url = new Url($event->domain . ltrim($baseUrl, '/'));

			foreach ($otherUrls as $lang => $otherUrl) {
				$langDomain = $event->site->getDomains()[$lang] ?? null;
				if (!$langDomain || !$langDomain->isActive) {
					continue;
				}

				$domain  = $langDomain->isDefault ? $langDomain->getDomain() : $langDomain->getDomain() . '/' . $lang;
				$linkExt = new Link($lang, 'https://' . $domain . '/' . ltrim($otherUrl, '/'));
				$url->addExtension($linkExt);
			}

			$event->addToResult($url);
		}
	}
}
