<?php declare(strict_types = 1);

namespace DynamicModule\Model\Traits;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use DynamicModule\Model\Entities\Field;
use Nette\Utils\Arrays;

/**
 * @property ArrayCollection $fields
 */
trait TTemplate
{
	#[ORM\Column(type: 'string', length: 255, nullable: false)]
	public string $template;

	/**
	 * @param string $text
	 */
	public function getText($text): string|array|null
	{
		return $this->getFieldsValues()[$text] ?? '';
	}

	public function getTexts(): array
	{
		return $this->getFieldsValues();
	}

	/**
	 * @param array $texts
	 */
	public function setTexts($texts): void
	{
		// tento kod je pro tt, ktere maji vice inputu (jako je napr. image)
		$existFields = $this->getFieldsByKey();
		foreach ($texts as $k => $v) {
			if (is_array($v) && !Arrays::every(array_keys($v), static fn($val) => strlen((string) $val) === 2)) { // napr tt image ktere ma 3 inputy, strlen 2 je pro lang
				foreach ($v as $k1 => $v1) {
					$texts[$k1] = $v1;
				}
				unset($texts[$k]);
				foreach ($existFields as $defK => $defV) {
					if ($defK === $k) {
						if (is_array($defV)) {
							if (!is_array($texts[$k])) {
								// if new value is not multiLang
								foreach ($defV as $field) {
									$this->fields->removeElement($field);
								}

								unset($existFields[$defK]);
								break;
							}
						} else {
							// if new value is multiLang
							$this->fields->removeElement($existFields[$defK]);
							unset($existFields[$defK]);
							break;
						}

						break;
					}
				}
			}
		}

		foreach ($texts as $k => $v) {
			/** @var array{supposed?: int, is?: int, missingLangs?: array} $langStats */
			$langStats = [];

			// edit
			$break = false;

			foreach ($existFields as $defK => $defV) {
				if ($defK === $k) {
					if (is_array($defV)) {
						if (!is_array($texts[$k])) {
							// if new value is not multiLang
							foreach ($defV as $field) {
								$this->fields->removeElement($field);
							}

							unset($existFields[$defK]);
							break;
						} else {
							$langStats = ['supposed'     => count($v), 'is' => count($defV),
							              'missingLangs' => array_keys($v)];
							foreach ($defV as $lang => $field) {
								$field->value = $texts[$k][$lang] ?? null;
								if (($position = array_search($lang, $langStats['missingLangs'], true)) !== false) {
									unset($langStats['missingLangs'][$position]);
								}
							}
						}
					} else {
						if (is_array($v)) {
							// if new value is multiLang
							$this->fields->removeElement($existFields[$defK]);
							unset($existFields[$defK]);
							break;
						} else {
							$defV->value = $v;
						}
					}

					$break = true;
					break;
				}
			}

			// situace kdy v db jsou fieldy jen v nekterych mutacich, ale field z formulare je vsech mutacich -> ostatni jsou potreba dopridat
			if (isset($langStats['supposed'], $langStats['is']) && $langStats['supposed'] !== $langStats['is'] && count(
					$langStats['missingLangs'],
				) > 0) {
				foreach ($v as $lang => $val) {
					if (in_array($lang, $langStats['missingLangs'], true)) {
						$this->fields->add(new Field($k, $val, $lang));
					}
				}
			} else if (!$break) { // add
				if (is_array($v)) {
					foreach ($v as $lang => $val) {
						$this->fields->add(new Field($k, $val, $lang));
					}
				} else {
					$this->fields->add(new Field($k, $v));
				}
			}
		}

		// delete
		foreach (array_diff(array_keys($existFields), array_keys($texts)) as $key) {
			foreach ($existFields as $defK => $value) {

				if ($defK === $key) {
					$this->fields->removeElement($value);
					break;
				}
			}
		}
	}

}
