<?php declare(strict_types = 1);

namespace DynamicModule\AdminModule\Components\VirtualUrl;

use Core\AdminModule\Model\Sites;
use Core\Model\Http\Session;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use DynamicModule\AdminModule\Model\Features;
use DynamicModule\AdminModule\Model\FeatureValues;
use Navigations\AdminModule\Model\Navigations;
use Nette\Utils\ArrayHash;

class VirtualUrlFilterForm extends BaseControl
{
	public string $siteIdent;
	public array  $filter = [];

	protected Sites         $sites;
	protected Features      $features;
	protected FeatureValues $featureValues;
	protected Navigations   $navigations;
	protected Session       $session;

	public function __construct(
		string        $siteIdent,
		Sites         $sites,
		Features      $features,
		FeatureValues $featureValues,
		Navigations   $navigations,
		Session       $session
	)
	{
		$this->siteIdent     = $siteIdent;
		$this->sites         = $sites;
		$this->features      = $features;
		$this->featureValues = $featureValues;
		$this->navigations   = $navigations;
		$this->session       = $session;

		$this->filter = $this->session->getSection('virtualUrlFilterForm')->get('values/' . $this->siteIdent) ?? [];
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();
		$form->setShowLangSwitcher(false);

		$titlePrefix = 'dynamicModule.virtualUrl.';

		$form->addSubmit('save', 'default.update');

		$form->addText('urlExact', $titlePrefix . 'urlExact');
		$form->addText('urlContain', $titlePrefix . 'urlContain');

		$form->addText('title', $titlePrefix . 'title');
		$form->addSelect('hasTitle', $this->t($titlePrefix . 'hasTitle'), [
			'' => '',
			0  => $this->t('default.no'),
			1  => $this->t('default.yes'),
		])->setTranslator(null);

		$form->addSelect('inSitemap', $this->t($titlePrefix . 'inSitemap'), [
			'' => '',
			0  => $this->t('default.no'),
			1  => $this->t('default.yes'),
		])->setTranslator(null);

		$form->addCheckboxList('navigations', $this->t($titlePrefix . 'navigations'), $this->navigations->getOptionsForSelect())
			->setTranslator(null);

		// Features
		$flat         = [];
		$featureTexts = $this->features->getOptionsForSelect();
		foreach ($this->featureValues->getOptionsForSelectGrouped() as $featureId => $values) {
			$flat[] = [
				'id'     => 'f' . $featureId,
				'name'   => $featureTexts[$featureId],
				'parent' => 0,
			];

			foreach ($values as $valueId => $value) {
				$flat[] = [
					'id'     => $valueId,
					'name'   => $value,
					'parent' => 'f' . $featureId,
				];
			}
		}
		$form->addCheckboxNestedList('features', $titlePrefix . 'features', $flat);

		$form->addSubmit('save2', 'default.update');

		$form->onSuccess[] = [$this, 'formSuccess'];

		$form->setDefaults($this->filter);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		$this->filter = (array) $values;

		$this->session->getSection('virtualUrlFilterForm')->set('values/' . $this->siteIdent, $this->filter);

		return true;
	}
}
