<?php declare(strict_types = 1);

namespace DynamicModule\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Strings;
use Core\Model\Helpers\Traits\TPosition;
use Core\Model\Helpers\Traits\TPublish;
use Doctrine\ORM\Mapping\ClassMetadataInfo;
use Doctrine\ORM\Query\Expr\Join;
use DynamicModule\Model\CacheService;
use DynamicModule\Model\Entities\Feature;
use DynamicModule\Model\Entities\FeatureValue;
use Exception;
use Nette\Caching\Cache;

/**
 * @method FeatureValue|null getReference($id)
 * @method FeatureValue[] getAll()
 * @method FeatureValue|null get($id)
 */
class FeatureValues extends BaseEntityService
{
	use TPublish;
	use TPosition;

	protected              $entityClass = FeatureValue::class;
	protected CacheService $cacheService;
	protected Translator   $translator;

	public function __construct(
		CacheService $cacheService,
		Translator   $translator
	)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	public function getOptionsForSelect(): array
	{
		$result = [];

		foreach ($this->getEr()->createQueryBuilder('fv')->select('fv.id, fvt.name')
			         ->innerJoin('fv.texts', 'fvt', Join::WITH, 'fvt.lang = :lang')
			         ->setParameter('lang', $this->translator->getLocale())
			         ->orderBy('fv.position')->getQuery()->getArrayResult() as $row) {
			$result[$row['id']] = $row['name'];
		}

		return $result;
	}

	public function getOptionsForSelectGrouped(): array
	{
		$result = [];

		foreach ($this->getEr()->createQueryBuilder('fv')->select('fv.id, fvt.name, IDENTITY(fv.feature) as feature')
			         ->innerJoin('fv.texts', 'fvt', Join::WITH, 'fvt.lang = :lang')
			         ->setParameter('lang', $this->translator->getLocale())
			         ->orderBy('fv.position')->getQuery()->getArrayResult() as $row) {
			$result[$row['feature']][$row['id']] = $row['name'];
		}

		return $result;
	}
}
