<?php declare(strict_types = 1);

namespace DynamicModule\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use DynamicModule\Model\CacheService;
use DynamicModule\Model\Entities\VirtualUrl;
use Exception;

/**
 * @method VirtualUrl|null getReference($id)
 * @method VirtualUrl[] getAll()
 * @method VirtualUrl|null get($id)
 */
class VirtualUrls extends BaseEntityService
{
	protected              $entityClass = VirtualUrl::class;
	protected CacheService $cacheService;
	protected Translator   $translator;

	public function __construct(
		CacheService $cacheService,
		Translator   $translator
	)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	public function addToSitemap(array $ids): bool
	{
		try {
			$this->em->createQueryBuilder()
				->update($this->entityClass, 'vu')
				->set('vu.addToSitemap', 1)
				->where('vu.id IN (:ids)')
				->setParameter('ids', $ids)
				->getQuery()
				->execute();

			return true;
		} catch (Exception $e) {

		}

		return false;
	}

	public function removeFromSitemap(array $ids): bool
	{
		try {
			$this->em->createQueryBuilder()
				->update($this->entityClass, 'vu')
				->set('vu.addToSitemap', 0)
				->where('vu.id IN (:ids)')
				->setParameter('ids', $ids)
				->getQuery()
				->execute();

			return true;
		} catch (Exception $e) {

		}

		return false;
	}
}
