<?php declare(strict_types = 1);

namespace DynamicModule\AdminModule\Presenters;

use DynamicModule\AdminModule\Components\GroupsGrid;
use DynamicModule\AdminModule\Components\IGroupsGridFactory;
use DynamicModule\AdminModule\Components\IMembersGridFactory;
use DynamicModule\AdminModule\Components\MembersGrid;
use DynamicModule\Model\Repository\Groups;
use DynamicModule\Model\Repository\Members;
use Nette\Application\BadRequestException;
use Nette\Utils\Strings;

class DefaultPresenter extends BasePresenter
{
	/** @var string */
	protected string $moduleKey;

	/** @var Groups @inject */
	public Groups $groups;

	/** @var Members @inject */
	public Members $members;

	/**
	 * @param mixed $element
	 * @throws BadRequestException
	 */
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		$moduleKey = $this->getParameter('id');
		if (!$moduleKey || !$this->getUser()->isAllowed($this->getFullModuleName() . ':' . ucfirst($moduleKey), 'access')) {
			$this->error();
		}

		$this->moduleKey = $this->getParameter('id');
	}

	/**
	 * @param mixed $id
	 */
	public function actionDefault($id): void
	{
		if ($navigationItem = $this->searchNavigationItem($this->moduleKey, $this['navigationSidebar']->getData())) {
			$this->setHeader($navigationItem['title'], $navigationItem['ico']);
			$this->setTitle($this->t($navigationItem['title']));
		}

		$this['navigation']->setData([
			'header' => [
				[
					'title' => 'dynamicModule.menu.addMember',
					'ico'   => 'plus',
					'link'  => $this->link('membersGrid:add!'),
					'class' => 'ajax',
				],
				[
					'title' => 'dynamicModule.menu.addGroup',
					'ico'   => 'plus',
					'link'  => $this->link('groupsGrid:add!'),
					'class' => 'ajax',
				],
			],
		]);
	}

	/**
	 * @param IMembersGridFactory $factory
	 *
	 * @return MembersGrid
	 */
	public function createComponentMembersGrid(IMembersGridFactory $factory): MembersGrid
	{
		return $factory->create($this->moduleKey);
	}

	/**
	 * @param IGroupsGridFactory $factory
	 *
	 * @return GroupsGrid
	 */
	public function createComponentGroupsGrid(IGroupsGridFactory $factory): GroupsGrid
	{
		return $factory->create($this->moduleKey);
	}

	/**
	 * @param string $needle
	 * @param array  $haystack
	 *
	 * @return array|null
	 */
	protected function searchNavigationItem(string $needle, array $haystack): ?array
	{
		foreach ($haystack as $key => $value) {
			$link = $value[$needle]['link'][0];
			if (is_array($value[$needle]['link']) && $link !== null && Strings::contains($link, 'DynamicModule')) {
				return $value[$needle];
			}
		}

		return null;
	}

}
