<?php declare(strict_types = 1);

namespace DynamicModule\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use DynamicModule\AdminModule\Components\Features\FeatureForm;
use DynamicModule\AdminModule\Components\Features\FeaturesGrid;
use DynamicModule\AdminModule\Components\Features\FeatureValueForm;
use DynamicModule\AdminModule\Components\Features\FeatureValuesGrid;
use DynamicModule\AdminModule\Components\Features\IFeatureFormFactory;
use DynamicModule\AdminModule\Components\Features\IFeaturesGridFactory;
use DynamicModule\AdminModule\Components\Features\IFeatureValueFormFactory;
use DynamicModule\AdminModule\Components\Features\IFeatureValuesGridFactory;
use DynamicModule\Model\Entities\Feature;
use DynamicModule\Model\Entities\FeatureValue;

class ModuleFeaturesPresenter extends BasePresenter
{
	public function actionDefault(): void
	{
		$this->setHeader('dynamicModule.title.moduleFeatures', 'fa fa-list');

		$this['navigation']->setData([
			'header' => [
				[
					'title' => 'eshopCatalog.menu.addFeature',
					'link'  => 'ModuleFeatures:addFeature',
					'ico'   => 'plus',
				],
			],
		]);
	}

	public function actionAddFeature(): void
	{
		$this->setHeader('dynamicModule.title.newFeature', 'fa fa-list');
	}

	public function actionAddFeatureValue(): void
	{
		$this->setHeader('dynamicModule.title.newFeatureValue', 'fa fa-list-alt');
	}

	/**
	 * @param int|string $id
	 */
	public function actionEditFeature($id): void
	{
		$feature = $this->em->getRepository(Feature::class)->find((int) $id);
		$link    = null;

		if ($this->getParameter('id')) {
			$link = $this->link('ModuleFeatures:addFeatureValue', ['featureId' => $this->getParameter('id')]);
		}

		if (!$feature) {
			$this->error();
		}

		$this->setHeader('dynamicModule.title.editFeature', 'fa fa-list-alt');

		$this->template->feature = $feature;

		$this['navigation']->setData(['header' => [
			[
				'title' => 'dynamicModule.menu.addFeatureValue',
				'link'  => $link ?: 'ModuleFeatures:addFeatureValue',
				'ico'   => 'plus',
			],
		]]);
	}

	/**
	 * @param int|string $id
	 */
	public function actionEditFeatureValue($id): void
	{
		$featureValue = $this->em->getRepository(FeatureValue::class)->find($id);

		if (!$featureValue) {
			$this->error();
		}

		$this->setHeader('dynamicModule.title.editFeatureValue', 'fa fa-list-alt');
	}

	protected function createComponentFeaturesGrid(IFeaturesGridFactory $factory): FeaturesGrid
	{
		return $factory->create();
	}

	protected function createComponentFeatureValuesGrid(IFeatureValuesGridFactory $factory): FeatureValuesGrid
	{
		/** @var ?Feature $feature */
		$feature = $this->em->getRepository(Feature::class)->find((int) $this->getParameter('id'));

		if (!$feature) {
			$this->error();
		}

		return $factory->create($feature);
	}

	protected function createComponentFeatureForm(IFeatureFormFactory $feature): FeatureForm
	{
		$control = $feature->create();

		if ($this->getParameter('id')) {
			$control->setFeature((int) $this->getParameter('id'));
		}

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('ModuleFeatures:editFeature', $form->getCustomData('featureId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('ModuleFeatures:default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('ModuleFeatures:default');
		};

		return $control;
	}

	protected function createComponentFeatureValueForm(IFeatureValueFormFactory $factory): FeatureValueForm
	{
		$control = $factory->create();
		if ($this->getParameter('id')) {
			$control->setFeatureValue((int) $this->getParameter('id'));
		}

		if ($this->getParameter('featureId')) {
			$control->setFeature((int) $this->getParameter('featureId'));
		}

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('ModuleFeatures:editFeatureValue', $form->getCustomData('featureValueId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('ModuleFeatures:editFeature', $form->getCustomData('featureId'));
		};

		$control['form']->onCancel[] = function(BaseForm $form) {
			$featureId = $form->getValues()['feature'];

			if ($featureId) {
				$this->redirect('ModuleFeatures:editFeature', $featureId);
			} else {
				$this->redirect('ModuleFeatures:default');
			}
		};

		return $control;
	}
}
