<?php declare(strict_types = 1);

namespace DynamicModule\Console\MultihubInstagram;

use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Doctrine\ORM\Tools\SchemaTool;
use DynamicModule\Model\Services\MultihubInstagramService;
use Google\Model\Reviews\ReviewsService;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class DownloadLatestMedia extends AbstractCommand
{
	/** @var MultihubInstagramService |null @inject */
	public ?MultihubInstagramService $multihubInstagramService = null;

	protected function configure(): void
	{
		$this->setName('dynamic-module:multihub-instagram:download-latest-media');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('MultihubInstagram: Downloading latest media');

		try {
			if (!$this->multihubInstagramService) {
				throw new \Exception('Service not found');
			}

			$this->multihubInstagramService->downloadLatestMedia();

			$output->writeLn('<info>[OK] - downloaded</info>');

			return 0;
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
