<?php declare(strict_types = 1);

namespace DynamicModule\DI;

use Core\DI\CompilerExtension;
use Nette;
use Nette\DI\Compiler;

class DynamicModuleExtension extends CompilerExtension
{
	public function loadConfiguration(): void
	{
		$path = APP_DIR . '/config/app/dynamicModule.neon';
		if (!file_exists($path)) {
			throw new \RuntimeException('Please create dynamicModule.neon in app/config/app');
		}


		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['DynamicModule' => 'DynamicModule\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class): void
	{
		parent::afterCompile($class);

		$init = $class->methods["initialize"];

		$init->addBody('DynamicModule\Model\DynamicModuleConfig::setParams($this->parameters[\'dynamicModule\']);');
		$init->addBody('$this->getService(\'dynamicmodule.admin.groups\')->checkRoots($this->parameters[\'adminNavigation\']);');
	}
}
