<?php declare(strict_types=1);

namespace DynamicModule\FrontModule\Model\Dao;

use Nette\SmartObject;

/**
 * @property-read int $id
 * @property-read string $key
 * @property-read string $lang
 * @property string $value
 */
class Field
{
	use SmartObject;

	/** @var string|object|null */
	protected $value;
	protected int $id;
	protected string $key;
	protected ?string $lang;

	public function __construct(string $key, ?string $value, ?string $lang, int $id)
	{
		$this->key = $key;
		$this->value = $value;
		$this->lang = $lang;
		$this->id = $id;
	}

	public function getId(): int
	{
		return $this->id;
	}

	public function getKey(): string
	{
		return $this->key;
	}

	/**
	 * @return string|object|null
	 */
	public function getValue()
	{
		return $this->value;
	}

	/**
	 * @param string|object|null $value
	 */
	public function setValue($value): void
	{
		$this->value = $value;
	}

	public function getLang(): ?string
	{
		return $this->lang;
	}

}
