<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Dao;

class FilterGroup
{
	public ?int    $id       = null;
	public ?string $name     = null;
	public int     $position = 9999;

	/** @var array<int, FilterItem> */
	public array $items = [];

	public function __construct(?int $id, ?string $name)
	{
		$this->id   = $id;
		$this->name = $name;
	}

	public function hasActive(): bool
	{
		foreach ($this->items as $item) {
			if ($item->isActive) {
				return true;
			}
		}

		return false;
	}
}
