<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Dao;

use Core\FrontModule\Model\Dao\Seo;
use Nette\SmartObject;

/**
 * @property-read int    $id
 * @property string      $title
 * @property string|null $lang
 * @property string      $template
 * @property Field[]     $fields
 */
class Member implements IFields
{
	use SmartObject;
	use TFields;

	protected int     $id;
	protected string  $title;
	protected ?string $lang;
	protected string  $template;
	protected array   $groupIds = [];

	public array $featureValueIds = [];

	/** @var array<int, MemberFeature> */
	public array $features = [];

	public ?string $module = null;
	public ?Seo    $seo    = null;
	public array   $params = [];

	public function __construct(int $id, string $title, string $template)
	{
		$this->id       = $id;
		$this->title    = $title;
		$this->template = $template;
	}

	public function getId(): int
	{
		return $this->id;
	}

	public function getTitle(): string
	{
		return $this->title;
	}

	public function setTitle(string $title): void
	{
		$this->title = $title;
	}

	public function getLang(): ?string
	{
		return $this->lang;
	}

	public function setLang(?string $lang): void
	{
		$this->lang = $lang;
	}

	public function getTemplate(): string
	{
		return $this->template;
	}

	public function setTemplate(string $template): void
	{
		$this->template = $template;
	}

	public function setGroupIds(array $groupIds): void { $this->groupIds = array_unique($groupIds); }

	public function getGroupIds(): array { return $this->groupIds; }

	/** @return mixed */
	public function getParam(string $key) { return $this->params[$key] ?? null; }
}
