<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Repository;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Query\Expr\Join;
use DynamicModule\FrontModule\Model\Dao;
use DynamicModule\Model\CacheService;
use DynamicModule\Model\Entities\Feature;
use DynamicModule\Model\Entities\FeatureValue;

class Features extends BaseEntityService
{
	/** @var string */
	protected              $entityClass = Feature::class;
	public Translator      $translator;
	protected CacheService $cacheService;

	protected array $cFeatures = [];

	public function __construct(
		Translator   $translator,
		CacheService $cacheService
	)
	{
		$this->translator   = $translator;
		$this->cacheService = $cacheService;
	}

	/**
	 * @return Dao\Feature[]
	 */
	public function getFeatures(array $ids): array
	{
		$result = [];
		$lang   = $this->translator->getLocale();
		$where  = [];
		$keys   = [];

		foreach ($ids as $id) {
			if (isset($this->cFeatures[$id])) {
				$result[$id] = $this->cFeatures[$id];
			} else {
				$keys[] = CacheService::getFeatureKey($id, $lang);
			}
		}

		foreach ($this->cacheService->featureCache->bulkLoad($keys) as $key => $value) {
			$tmp = CacheService::parseFeatureKey($key);

			if ($value) {
				$this->cFeatures[$tmp['id']] = $value;
				$result[$tmp['id']]          = $value;
			} else {
				$where[] = $tmp['id'];
			}
		}

		if (!empty($where)) {
			$values = [];

			foreach ($this->em->getRepository(FeatureValue::class)->createQueryBuilder('fv')
				         ->select('fv.id, fvt.name, fvt.icon, IDENTITY(fv.feature) as feature, fvt.rodM, fvt.rodZ, fvt.rodS')
				         ->innerJoin('fv.texts', 'fvt', Join::WITH, 'fvt.lang = :lang')
				         ->andWhere('fv.feature IN (' . implode(',', $where) . ')')
				         ->setParameters([
					         'lang' => $lang,
				         ])->getQuery()->getArrayResult() as $row) {
				$fv          = new Dao\FeatureValue($row['id'], (string) $row['name'], $row['icon']);
				$fv->nameRod = [
					'm' => $row['rodM'],
					'z' => $row['rodZ'],
					's' => $row['rodS'],
				];

				$values[$row['feature']][$row['id']] = $fv;
			}

			foreach ($this->getEr()->createQueryBuilder('f')
				         ->select('f.id, ft.name, f.position, f.urlPosition, f.urlPositionMulti, f.urlPositionPriority, f.urlPositionMultiPriority, ft.nameMulti')
				         ->innerJoin('f.texts', 'ft', Join::WITH, 'ft.lang = :lang')
				         ->andWhere('f.id IN (' . implode(',', $where) . ')')
				         ->setParameters([
					         'lang' => $lang,
				         ])->getQuery()->getArrayResult() as $row) {
				$feature                           = new Dao\Feature($row['id'], $row['name']);
				$feature->values                   = $values[$row['id']] ?? [];
				$feature->nameMulti                = $row['nameMulti'];
				$feature->position                 = (int) $row['position'];
				$feature->urlPosition              = (int) $row['urlPosition'];
				$feature->urlPositionMulti         = (int) $row['urlPositionMulti'];
				$feature->urlPositionPriority      = (int) $row['urlPositionPriority'];
				$feature->urlPositionMultiPriority = (int) $row['urlPositionMultiPriority'];

				$this->cacheService->featureCache->save(CacheService::getFeatureKey($row['id'], $lang), $feature);

				$this->cFeatures[$row['id']] = $feature;
				$result[$row['id']]          = $feature;
			}
		}

		return $result;
	}

	/**
	 * @param Dao\Member[] $members
	 */
	public function getForMembers(array $members): void
	{
		$lang       = $this->translator->getLocale();
		$featureIds = [];

		foreach ($members as $member) {
			foreach ($member->featureValueIds as $k => $v) {
				$featureIds[$v] = $v;
			}
		}

		if (!empty($featureIds)) {
			$features = $this->getFeatures($featureIds);

			foreach ($members as $member) {
				$memberFeatures = [];

				foreach ($member->featureValueIds as $valueId => $featureId) {
					if (isset($features[$featureId], $features[$featureId]->values[$valueId])) {
						$tmp         = clone $features[$featureId];
						$tmp->values = [];

						$memberFeatures[$valueId] = new Dao\MemberFeature($tmp, $features[$featureId]->values[$valueId]);
					}
				}

				$member->features = $memberFeatures;
			}
		}
	}
}
