<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Repository;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception;
use Doctrine\DBAL\ParameterType;
use Doctrine\ORM\Mapping\ClassMetadataInfo;
use DynamicModule\Model\Entities\Field;
use DynamicModule\FrontModule\Model\Dao;
use Contributte\Translation\Translator;

class Fields extends BaseEntityService
{
	/** @var string */
	protected $entityClass = Field::class;
	public Translator $translator;
	protected array $cEntities = [];

	public function __construct(Translator $translator)
	{
		$this->translator = $translator;
	}

	/**
	 * @return Dao\Field[]
	 * @throws Exception
	 */
	public function getByGroup(int $groupId): array
	{
		return $this->getByEntities('dynamicmodule__group_fields', 'group_id', [$groupId])[$groupId] ?? [];
	}

	/**
	 * @param int[] $groupIds
	 *
	 * @return Dao\Field[][]
	 * @throws Exception
	 */
	public function getByGroups(array $groupIds, ?string $lang = null): array
	{
		return $this->getByEntities('dynamicmodule__group_fields', 'group_id', $groupIds, $lang);
	}

	/**
	 * @return Dao\Field[]
	 * @throws Exception
	 */
	public function getByMember(int $memberId): array
	{
		return $this->getByEntities('dynamicmodule__member_fields', 'member_id', [$memberId])[$memberId] ?? [];
	}

	/**
	 * @param int[] $memberIds
	 *
	 * @return Dao\Field[][]
	 * @throws Exception
	 */
	public function getByMembers(array $memberIds): array
	{
		return $this->getByEntities('dynamicmodule__member_fields', 'member_id', $memberIds);
	}

	/**
	 * @param int[] $ids
	 * @throws Exception
	 */
	protected function getByEntities(string $joinTable, string $joinColumn, array $ids, ?string $lang = null): array
	{
		$tmp  = [];
		$oIds = $ids;
		$lang = $lang ?: $this->translator->getLocale();

		if (!isset($this->cEntities[$lang])) {
			$this->cEntities[$lang] = [];
		}

		foreach ($ids as $k => $id) {
			if (isset($this->cEntities[$lang][$joinColumn][$id])) {
				$tmp[$id] = $this->cEntities[$lang][$joinColumn][$id];
				unset($ids[$k]);
			}
		}

		if (!empty($ids)) {
			/** @var ClassMetadataInfo $metadata */
			$metadata  = $this->em->getClassMetadata($this->entityClass);
			$columns   = implode(', ', array_map(static fn(string $col): string => "`{$col}`", $metadata->getColumnNames()));
			$tableName = $metadata->getTableName();

			if (!$columns || !$tableName) {
				return [];
			}

			$sql    = "SELECT {$columns}, jt.{$joinColumn} FROM {$tableName} t JOIN {$joinTable} jt ON t.id = jt.field_id 
						WHERE jt.{$joinColumn} IN (:ids) AND (t.lang = :lang OR t.lang IS NULL)";
			$values = [
				'ids'  => $ids,
				'lang' => $lang,
			];
			$types  = [
				'ids'  => Connection::PARAM_INT_ARRAY,
				'lang' => ParameterType::STRING];
			$stmt   = $this->em->getConnection()->executeQuery($sql, $values, $types);

			foreach ($stmt->fetchAll() as $row) {
				$row['id']                           = (int) $row['id'];
				$tmp[$row[$joinColumn]][$row['key']] = new Dao\Field(...array_values($row));
			}

			foreach ($tmp as $id => $v) {
				$this->cEntities[$lang][$joinColumn][$id] = $v;
			}
		}

		$result = [];
		foreach ($oIds as $id) {
			if (isset($tmp[$id])) {
				$result[$id] = $tmp[$id];
			}
		}

		return $result;
	}
}
