<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Repository;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Sites;
use DynamicModule\FrontModule\Model\FilterUrlHelper;
use DynamicModule\Model\CacheService;
use DynamicModule\Model\Entities\VirtualUrl;
use Navigations\Model\NavigationConfig;
use Nette\Caching\Cache;

class VirtualUrls extends BaseEntityService
{
	/** @var string */
	protected                 $entityClass = VirtualUrl::class;
	public Translator         $translator;
	protected CacheService    $cacheService;
	protected FilterUrlHelper $filterUrlHelper;
	protected Sites           $sites;

	public function __construct(
		Translator      $translator,
		CacheService    $cacheService,
		FilterUrlHelper $filterUrlHelper,
		Sites           $sites
	)
	{
		$this->translator      = $translator;
		$this->cacheService    = $cacheService;
		$this->filterUrlHelper = $filterUrlHelper;
		$this->sites           = $sites;
	}

	public function getByUrl(string $siteIdent, string $lang, string $url): ?array
	{
		$cacheKey = $this->filterUrlHelper->getCacheKeyByUrl($siteIdent, $lang, $url);

		return $this->cacheService->filterCache->load($cacheKey, function(&$dep) use ($siteIdent, $lang, $url) {
			$dep = [
				Cache::EXPIRATION => '1 hour',
			];

			$showDefaultLangInUrl = NavigationConfig::load('showDefaultLangInUrl', false);
			$domain               = $this->sites->getCurrentSite()->getDomains()[$lang] ?? null;

			if (($domain && !$domain->isDefault) || $showDefaultLangInUrl) {
				$langPrefix = $lang;

				if ($lang === 'cs' && NavigationConfig::load('useCZinUrl') === true) {
					$langPrefix = 'cz';
				}

				$url = '/' . $langPrefix . $url;
			}

			return $this->em->getConnection()->fetchAssociative("SELECT 
    				vu.id, vu.relation_hash, vu.navigation,
    				vut.seo_title, vut.seo_description, vut.title, vut.description, vut.texts, vut.url,
    				GROUP_CONCAT(vufv.feature_value_id) as f
					FROM dynamicmodule__virtual_url_text vut
					INNER JOIN dynamicmodule__virtual_url vu ON vut.id = vu.id AND vu.site_ident = :siteIdent
					INNER JOIN dynamicmodule__virtual_url_feature_value vufv ON vu.id = vufv.virtual_url_id
					WHERE vut.locale = :lang AND vut.url = :url
					GROUP BY vu.id
					LIMIT 1
					", [
				'siteIdent' => $siteIdent,
				'lang'      => $lang,
				'url'       => $url,
			]);
		}) ?: null;
	}
}
