<?php declare(strict_types = 1);

namespace DynamicModule\Model;

use Core\Model\Lang\Langs;
use DynamicModule\Model\Repository\Members;
use Nette\Caching\Cache;
use Nette\Caching\Storage;

class CacheService
{
	public Cache $filterCache;
	public Cache $featureCache;
	public Cache $membersCache;
	public Langs $langs;

	public function __construct(
		Storage $cacheStorage,
		Langs   $langs
	)
	{
		$this->langs        = $langs;
		$this->featureCache = new Cache($cacheStorage, 'dynamicModuleFeature');
		$this->filterCache  = new Cache($cacheStorage, 'dynamicModuleFilter');
		$this->membersCache = new Cache($cacheStorage, Members::CACHE_NAMESPACE);
	}

	public static function getFeatureKey(int $id, string $lang): string { return 'feature/' . $id . '/' . $lang; }

	public static function parseFeatureKey(string $key): array
	{
		$tmp = explode('/', $key);

		return [
			'id'   => (int) $tmp[1],
			'lang' => $tmp[2],
		];
	}

	public function removeFeature(int $id): void
	{
		foreach ($this->langs->getLangs(false) as $lang) {
			$this->featureCache->remove(self::getFeatureKey($id, $lang->getTag()));
		}
	}

	public function removeMember(int $id): void
	{
		foreach ($this->langs->getLangs(false) as $lang) {
			$this->membersCache->remove('member/' . $lang->getTag() . '/' . $id);
		}
	}
}
