<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="dynamicmodule__feature", indexes={@ORM\Index(name="published", columns={"id", "is_published"})})
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener", "DynamicModule\Model\Listeners\FeatureCacheListener"})
 */
class Feature
{
	use TIdUnsigned;
	use TTranslateListener;

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(type="integer")
	 */
	protected int $position;

	/**
	 * @ORM\Column(type="smallint", length=1, options={"default":1})
	 */
	public int $isPublished = 1;

	/**
	 * @var Collection<string, FeatureText>
	 * @ORM\OneToMany(targetEntity="FeatureText", mappedBy="feature", indexBy="lang")
	 */
	public Collection $texts;

	/**
	 * @var Collection<int, FeatureValue>
	 * @ORM\OneToMany(targetEntity="FeatureValue", mappedBy="feature", indexBy="id")
	 */
	public Collection $values;

	/**
	 * @ORM\Column(type="integer", nullable=true, options={"unsigned":true, "default": 0})
	 */
	public int $urlPosition = 0;

	/**
	 * @ORM\Column(type="integer", nullable=true, options={"unsigned":true, "default": 0})
	 */
	public int $urlPositionMulti = 0;

	/**
	 * @ORM\Column(type="integer", nullable=true, options={"default": 0})
	 */
	public int $urlPositionPriority = 0;

	/**
	 * @ORM\Column(type="integer", nullable=true, options={"default": 0})
	 */
	public int $urlPositionMultiPriority = 0;

	public function __construct()
	{
		$this->texts  = new ArrayCollection;
		$this->values = new ArrayCollection;
		$this->setPosition(-1);
	}

	public function setPosition(int $position): self
	{
		$this->position = $position;

		return $this;
	}

	public function getPosition(): int { return $this->position; }
}
