<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="dynamicmodule__feature_text", indexes={@ORM\Index(name="feature", columns={"id", "lang"})})
 * @ORM\Entity
 * @ORM\EntityListeners({"DynamicModule\Model\Listeners\FeatureCacheListener"})
 */
class FeatureText
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Feature", inversedBy="texts")
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Feature $feature;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2)
	 */
	public string $lang;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $name = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $nameMulti = null;

	public function __construct(Feature $feature, string $lang)
	{
		$this->feature = $feature;
		$this->lang    = $lang;
	}
}
