<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="dynamicmodule__feature_value", indexes={@ORM\Index(name="published", columns={"id", "is_published"})})
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener", "DynamicModule\Model\Listeners\FeatureCacheListener"})
 */
class FeatureValue
{
	use TIdUnsigned;
	use TTranslateListener;

	/**
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="Feature", inversedBy="id")
	 * @ORM\JoinColumn(name="feature_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public ?Feature $feature = null;

	/**
	 * @var Collection<string, FeatureValueText>
	 * @ORM\OneToMany(targetEntity="FeatureValueText", mappedBy="featureValue", indexBy="lang")
	 */
	public Collection $texts;

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(type="integer")
	 */
	public int $position;

	/**
	 * @ORM\Column(type="smallint", nullable=true, options={"default" = 1})
	 */
	public int $isPublished = 1;

	public function __construct()
	{
		$this->texts       = new ArrayCollection;
		$this->isPublished = 1;
		$this->setPosition(-1);
	}

	public function setPosition(int $position): self
	{
		$this->position = $position;

		return $this;
	}

	public function getPosition(): int { return $this->position; }
}
