<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="dynamicmodule__feature_value_text", indexes={@ORM\Index(name="feature_value", columns={"id", "lang"})})
 * @ORM\Entity
 * @ORM\EntityListeners({"DynamicModule\Model\Listeners\FeatureCacheListener"})
 */
class FeatureValueText
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="FeatureValue", inversedBy="featureValueTexts")
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public FeatureValue $featureValue;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2)
	 */
	public string $lang;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $name = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $rodM = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $rodZ = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $rodS = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $icon = null;

	public function __construct(FeatureValue $featureValue, string $lang)
	{
		$this->featureValue = $featureValue;
		$this->lang         = $lang;
	}
}
