<?php declare(strict_types=1);

namespace DynamicModule\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="dynamicmodule__field")
 * @ORM\Entity
 */
class Field
{
	use TId;

	/**
	 * @var string
	 * @ORM\Column(name="`key`", type="string", length=255, nullable=false)
	 */
	public string $key;

	/**
	 * @var string
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $value;

	/**
	 * @var string
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $lang;

	/**
	 * Field constructor.
	 * @param string $key
	 * @param null $value
	 * @param string|null $lang
	 */
	public function __construct(string $key, $value = null, string $lang = null)
	{
		$this->key   = $key;
		$this->value = $value;
		$this->lang  = $lang;
	}

}